﻿Imports System
Imports System.Drawing
Imports System.Collections
Imports System.ComponentModel
Imports System.Windows.Forms
Imports System.Data
Imports NationalInstruments.NI4882

Public Class frmU3800_Ext_SG_VCorrection
    Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

    '************************************
    '* Setting acquisition of a Textbox *
    '************************************
    Private Sub GetSetting()
        U38_GpibAddress = CInt(Txt_U38_GPIB_Address.Text)
        Call WriteIniFile_U38_GPIB_Adrs(Txt_U38_GPIB_Address.Text)

        SG_GpibAddress = CInt(Txt_SG_GPIB_Address.Text)
        Call WriteIniFile_SG_GPIB_Adrs(Txt_SG_GPIB_Address.Text)

        SG_OutputLevel = CSng(Txt_SG_Out_Level.Text)
        Call WriteIniFile_SG_OUT_LVL(Txt_SG_Out_Level.Text)

        If Rad_VCorr_Type1.Checked = True Then
            Call WriteIniFile_U38_VCorr_Type(Rad_VCorr_Type1.Text)
        Else
            Call WriteIniFile_U38_VCorr_Type(Rad_VCorr_Type2.Text)
        End If
    End Sub

    '***********************************************************
    '* U3800 External SG Vector Correction Start               *
    '*                                                         *
    '* GPIB I/F                                                *
    '*   National Instruments GPIB Interfaces                  *
    '*                                                         *
    '* E8257D (Agilent) PSG Analog Signal Generator            *
    '*   GPIB (SCIPI) Command                                  *
    '*   SG_OUTPUT__CMD = "OUTP "                              *
    '*   SG_OUT_ON__CMD = "ON"                                 *
    '*   SG_OUT_OFF_CMD = "OFF"                                *
    '*   SG_OUT_LVL_CMD = "SOUR:POW "                          *
    '*   SG_OUT_LVL_UNT = "DBM"                                *
    '*   SG_SET_FRQ_CMD = "SOUR:FREQ "                         *
    '*   SG_SET_FRQ_UNT = "HZ"                                 *
    '*                                                         *
    '***********************************************************
    Private Sub Btn_VCorrStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_VCorrStart.Click
        Dim i As Integer
        Dim buf As String
        Dim VCorr_TtlCnt As Integer
        Dim strVCorr_TtlCnt As String
        Dim CentFreq As Double
        Dim OfstFreq As Double
        Dim strFreq As String
        Dim msg_rtn As Microsoft.VisualBasic.MsgBoxResult

        Lbl_SG_Start_Freq.Text = ""
        Lbl_SG_Step_Freq.Text = ""
        Lbl_SG_End_Freq.Text = ""
        Lbl_SG_Current_Freq.Text = ""
        Lbl_Count.Text = "/"

        Call GetSetting() ' U3800 & SG Setting acquisition of a Textbox.
        buf = Space(20)

        '*** GPIB ****
        GpibConnect = True
        If U38_GpibAddress > -1 And SG_GpibAddress > -1 And (U38_GpibAddress <> SG_GpibAddress) Then
            U38_GpibDevice = New Device(U38_GpibBoardId, U38_GpibAddress, U38_GpibSecondaryAddress)
            SG_GpibDevice = New Device(SG_GpibBoardId, SG_GpibAddress, SG_GpibSecondaryAddress)
        Else
            GpibConnect = False
        End If

        If GpibConnect = False Then Exit Sub
        Call U38_GpibDevice.Clear()                 'Performs a device clear.
        Call SG_GpibDevice.Clear()                  'Performs a device clear.

        Call U38_GpibDevice.Write("RFE")
        Call U38_GpibDevice.Write("VCSIGSRC EXT")   'SigSrc EXT

        Call U38_GpibDevice.Write("CF?")
        buf = U38_GpibDevice.ReadString(20)
        CentFreq = CDbl(buf)
        strFreq = CStr(CentFreq)
        Call SG_GpibDevice.Write(SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
        Lbl_SG_Start_Freq.Text = buf : Lbl_SG_Start_Freq.Refresh()

        'Set SG output on
        Call SG_GpibDevice.Write(SG_OUT_ON__CMD)

        'Set SG output level
        Call SG_GpibDevice.Write(SG_OUT_LVL_CMD & CStr(SG_OutputLevel) & SG_OUT_LVL_UNT)
        Call Sleep(500)

        VCorrAbort = False

        If Me.Rad_VCorr_Type1.Checked = True Then           '*** Specific Span ***
            'Xmath 1.Power Ratio Phase Diff Execute ON/OFF
            Call U38_GpibDevice.Write("XPRPDON?") : buf = U38_GpibDevice.ReadString(20) : i = CLng(buf)
            'Xmath 2.Differential Execute ON/OFF
            Call U38_GpibDevice.Write("XDIFFON?") : buf = U38_GpibDevice.ReadString(20) : i = i + CLng(buf)
            'Xmath 4.Power Math Execute ON/OFF
            Call U38_GpibDevice.Write("XMATHON?") : buf = U38_GpibDevice.ReadString(20) : i = i + CLng(buf)
            If i = 0 Then
                msg_rtn = MsgBox("Xmath Function OFF.", vbOKOnly)
                GoTo GpibOffline
            End If

            Call U38_GpibDevice.Write("VCFSEXTINIT")        '     Initialize Specific Span external SG vector correction.
            Call U38_GpibDevice.Write("VCFSEXTSTPSZ?")      '     Get Specific Span external SG vector correction total count.
            buf = U38_GpibDevice.ReadString(20)

            VCorr_TtlCnt = CLng(buf)                        '     External SG vector correction total count.
            strVCorr_TtlCnt = CStr(VCorr_TtlCnt)

            Call U38_GpibDevice.Write("VCFA?")              '     Start Freq.
            buf = U38_GpibDevice.ReadString(20)
            CentFreq = CDbl(buf)
            strFreq = CStr(CentFreq)
            Call SG_GpibDevice.Write(SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
            Call Sleep(1000)
            Lbl_SG_Start_Freq.Text = buf : Lbl_SG_Start_Freq.Refresh()
            Call U38_GpibDevice.Write("VCFB?")              '     Stop  Freq.
            buf = U38_GpibDevice.ReadString(20)
            Lbl_SG_End_Freq.Text = buf : Lbl_SG_End_Freq.Refresh()
            Call U38_GpibDevice.Write("VCFSTEP?")           '     Step  Freq.
            buf = U38_GpibDevice.ReadString(20)
            Lbl_SG_Step_Freq.Text = buf : Lbl_SG_Step_Freq.Refresh()

            Lbl_Count.Text = "0/" & strVCorr_TtlCnt
            Lbl_Count.Refresh()

            For i = 1 To VCorr_TtlCnt
                If VCorrAbort = True Then Exit For
                Call U38_GpibDevice.Write("VCFSEXTIDX " & CStr(i))
                Call U38_GpibDevice.Write("CF?") : buf = U38_GpibDevice.ReadString(20)
                CentFreq = CDbl(buf)
                strFreq = CStr(CentFreq)
                Lbl_SG_Current_Freq.Text = strFreq
                Lbl_SG_Current_Freq.Refresh()
                Call SG_GpibDevice.Write(SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
                Call Sleep(1000)
                Call U38_GpibDevice.Write("VCFSEXTEXE")
                Lbl_Count.Text = CStr(i) & " / " & strVCorr_TtlCnt
                Lbl_Count.Refresh()
                Application.DoEvents()
            Next i

            If VCorrAbort = False Then
                Call U38_GpibDevice.Write("VCFSEXTFINISH")  '     End Specific Span vector correction.
            Else
                Call U38_GpibDevice.Write("VCFSEXTABORT")   '     Abort Specific Span vector correction.
                Call U38_GpibDevice.Write("VCSIGSRC INT")   '     SigSrc INT
            End If
        Else                                                '*** InBand ***
            Call U38_GpibDevice.Write("VCINBEXTINIT")       '     Initialize InBand external SG vector correction.
            Call U38_GpibDevice.Write("VCINBEXTSTPSZ?")     '     Get InBand external SG vector correction total count.
            buf = U38_GpibDevice.ReadString(20)
            VCorr_TtlCnt = CLng(buf)                        '     External SG vector correction total count.
            strVCorr_TtlCnt = CStr(VCorr_TtlCnt)

            Lbl_Count.Text = "0/" & strVCorr_TtlCnt
            Lbl_Count.Refresh()

            For i = 1 To VCorr_TtlCnt
                If VCorrAbort = True Then Exit For
                Call U38_GpibDevice.Write("VCINBEXTIDX " & CStr(i))
                Call U38_GpibDevice.Write("VCINBEXTFO?") : buf = U38_GpibDevice.ReadString(20)
                OfstFreq = CDbl(buf)
                Call U38_GpibDevice.Write("CF?") : buf = U38_GpibDevice.ReadString(20)
                CentFreq = CDbl(buf)
                strFreq = CStr(CentFreq + OfstFreq)
                Lbl_SG_Current_Freq.Text = strFreq
                Lbl_SG_Current_Freq.Refresh()
                Call SG_GpibDevice.Write(SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
                Call Sleep(1000)
                Call U38_GpibDevice.Write("VCINBEXTEXE")
                Lbl_Count.Text = CStr(i) & " / " & strVCorr_TtlCnt
                Lbl_Count.Refresh()
                Application.DoEvents()
            Next i

            If VCorrAbort = False Then
                Call U38_GpibDevice.Write("VCINBEXTFINISH") '     End InBand vector correction.
            Else
                Call U38_GpibDevice.Write("VCINBEXTABORT")  '     Abort InBand vector correction.
                Call U38_GpibDevice.Write("VCSIGSRC INT")   '     SigSrc INT
            End If
        End If

GpibOffline:
        Call U38_GpibDevice.Dispose()
        Call SG_GpibDevice.Dispose()

    End Sub

    '*********************************************
    '* U3800 External SG Vector Correction Abort *
    '*********************************************
    Private Sub Btn_VCorrAbort_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_VCorrAbort.Click
        VCorrAbort = True
    End Sub

    Private Sub frmU3800_Ext_SG_VCorrection_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        VCorrAbort = False

        U38_GpibAddress = CInt(Trim(ReadIniFile_U38_GPIB_Adrs()))
        Txt_U38_GPIB_Address.Text = CStr(U38_GpibAddress)
        Call WriteIniFile_U38_GPIB_Adrs(Txt_U38_GPIB_Address.Text)

        SG_GpibAddress = CInt(Trim(ReadIniFile_SG_GPIB_Adrs()))
        Txt_SG_GPIB_Address.Text = CStr(SG_GpibAddress)
        Call WriteIniFile_SG_GPIB_Adrs(Txt_SG_GPIB_Address.Text)

        SG_OutputLevel = CSng(Trim(ReadIniFile_SG_OUT_LVL()))
        Txt_SG_Out_Level.Text = CStr(SG_OutputLevel)
        Call WriteIniFile_SG_OUT_LVL(Txt_SG_Out_Level.Text)

        If "Specific Span" = Trim(ReadIniFile_U38_VCorr_Type()) Then
            Rad_VCorr_Type1.Checked = True
            Rad_VCorr_Type2.Checked = False
            Call WriteIniFile_U38_VCorr_Type(Rad_VCorr_Type1.Text)
        Else
            Rad_VCorr_Type1.Checked = False
            Rad_VCorr_Type2.Checked = True
            Call WriteIniFile_U38_VCorr_Type(Rad_VCorr_Type2.Text)
        End If

        SG_OUTPUT__CMD = Trim(ReadIniFile_SG_OUT_STS_Cmd())
        Call WriteIniFile_SG_OUT_STS_Cmd(SG_OUTPUT__CMD)

        SG_OUT_ON__CMD = Trim(ReadIniFile_SG_OUT_ON_Para())
        Call WriteIniFile_SG_OUT_ON_Para(SG_OUT_ON__CMD)
        SG_OUT_ON__CMD = SG_OUTPUT__CMD & " " & SG_OUT_ON__CMD

        SG_OUT_OFF_CMD = Trim(ReadIniFile_SG_OUT_OFF_Para())
        Call WriteIniFile_SG_OUT_OFF_Para(SG_OUT_OFF_CMD)
        SG_OUT_OFF_CMD = SG_OUTPUT__CMD & " " & SG_OUT_OFF_CMD

        SG_OUT_LVL_CMD = Trim(ReadIniFile_SG_OUT_LVL_Cmd())
        Call WriteIniFile_SG_OUT_LVL_Cmd(SG_OUT_LVL_CMD)
        SG_OUT_LVL_CMD = SG_OUT_LVL_CMD & " "

        SG_OUT_LVL_UNT = Trim(ReadIniFile_SG_OUT_LVL_Unit())
        Call WriteIniFile_SG_OUT_LVL_Unit(SG_OUT_LVL_UNT)

        SG_SET_FRQ_CMD = Trim(ReadIniFile_SG_Freq_Cmd())
        Call WriteIniFile_SG_Freq_Cmd(SG_SET_FRQ_CMD)
        SG_SET_FRQ_CMD = SG_SET_FRQ_CMD & " "

        SG_SET_FRQ_UNT = Trim(ReadIniFile_SG_Freq_Unit())
        Call WriteIniFile_SG_Freq_Unit(SG_SET_FRQ_UNT)

    End Sub
End Class
